/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class LRUCache<K, V> {
    private final LinkedHashMap<K, V> map;

    public LRUCache(final int cacheSize) {
        this.map = new LinkedHashMap<K, V>(cacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    protected abstract V cacheMiss(K var1);

    public V get(K key) {
        V ret = this.map.get(key);
        if (ret == null) {
            ret = this.cacheMiss(key);
        }
        this.map.put(key, ret);
        return ret;
    }
}

