/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.errorLogging;

import com.sun.electric.api.minarea.errorLogging.AbstractErrorLogger;
import com.sun.electric.api.minarea.launcher.Launcher;
import java.awt.geom.PathIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ErrorToElectricReporter
extends AbstractErrorLogger {
    private String topCellName;

    public ErrorToElectricReporter(String topCellName) {
        this.topCellName = topCellName;
    }

    @Override
    public void printReports(long time) {
        try {
            String pid = Launcher.getPID();
            String fileName = "errorLog." + pid + ".xml";
            BufferedReader br = new BufferedReader(new InputStreamReader(ErrorToElectricReporter.class.getResourceAsStream("loggerHeader.xml")));
            PrintStream pstream = new PrintStream(new File(fileName));
            String line = null;
            while ((line = br.readLine()) != null) {
                pstream.println(line);
            }
            pstream.println("<ErrorLogger errorSystem=\"MinArea DRC\">");
            Object cellName = this.topCellName;
            if (((String)cellName).indexOf(123) == -1 && ((String)cellName).indexOf(125) == -1) {
                cellName = (String)cellName + "{lay}";
            }
            pstream.println("\t<GroupLog message=\"" + (String)cellName + "\">");
            this.sortViolations();
            for (AbstractErrorLogger.MinAreaViolation violation : this.violations) {
                pstream.println("\t\t<MessageLog message=\"Minimum Area Violation: actual = " + String.valueOf(violation.getMinArea()) + "\" cellName=\"" + (String)cellName + "\">");
                if (violation.getShape() == null) {
                    pstream.println("\t\t\t<ERRORTYPEPOINT pt=\"(" + ErrorToElectricReporter.scaleCoord(violation.getX()) + "," + ErrorToElectricReporter.scaleCoord(violation.getY()) + ")\" cellName=\"" + (String)cellName + "\"/>");
                } else {
                    pstream.println("\t\t\t<ERRORTYPEPOLY cellName=\"" + (String)cellName + "\">");
                    PathIterator pit = violation.getShape().getPathIterator(null);
                    double[] coords = new double[6];
                    double moveX = Double.NaN;
                    double moveY = Double.NaN;
                    double lastX = Double.NaN;
                    double lastY = Double.NaN;
                    while (!pit.isDone()) {
                        switch (pit.currentSegment(coords)) {
                            case 0: {
                                moveX = lastX = coords[0];
                                moveY = lastY = coords[1];
                                break;
                            }
                            case 1: {
                                this.reportLine(lastX, lastY, coords[0], coords[1], (String)cellName, pstream);
                                lastX = coords[0];
                                lastY = coords[1];
                                break;
                            }
                            case 4: {
                                this.reportLine(lastX, lastY, moveX, moveY, (String)cellName, pstream);
                                lastY = Double.NaN;
                                moveY = Double.NaN;
                                lastX = Double.NaN;
                                moveX = Double.NaN;
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        pit.next();
                    }
                    pstream.println("\t\t\t</ERRORTYPEPOLY>");
                }
                pstream.println("\t\t</MessageLog>");
            }
            pstream.println("\t</GroupLog>");
            pstream.println("</ErrorLogger>");
            br.close();
            pstream.flush();
            pstream.close();
            System.out.println("Output file written: " + fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void reportLine(double x1, double y1, double x2, double y2, String cellName, PrintStream pstream) {
        pstream.println("\t\t\t<ERRORTYPETHICKLINE p1=\"(" + ErrorToElectricReporter.scaleCoord(x1) + "," + ErrorToElectricReporter.scaleCoord(y1) + ")\" p2=\"(" + ErrorToElectricReporter.scaleCoord(x2) + "," + ErrorToElectricReporter.scaleCoord(y2) + ")\" cellName=\"" + cellName + "\"/>");
    }

    private static double scaleCoord(double coord) {
        return coord / 100.0;
    }
}

